using System;
using System.IO ;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using PixTwixLib;


namespace Project1
{

	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{


		private System.Windows.Forms.PictureBox Display;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private PixTwixLib.PixTwixClass PixTwix;

		private string undo_file;
		private int    magnification;
		private int    zoomed_left;
		private int    zoomed_top;
		private int    effect;
		private string path;

		private const string MSG_LOUPE = "Click anywhere on image to see LOUPE effect";
		private const int    FX_LOUPE = 0 ;
		private const string MSG_TWIRL = "Click anywhere on image to see TWIRL effect";
		private const int    FX_TWIRL = 1;
		private const string MSG_ZOOM = "Left click to zoom in, right click to zoom out";
		private const int    FX_ZOOM = 2;
		private const string MSG_MAGICWAND = "Click anywhere inside area you want to select";
		private const int    FX_MAGICWAND = 3;

		private System.Windows.Forms.Button btnUndo;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem miAttributes;
		private System.Windows.Forms.MenuItem miAttributesBrightness;
		private System.Windows.Forms.MenuItem miAttributesContrast;
		private System.Windows.Forms.MenuItem miBorder;
		private System.Windows.Forms.MenuItem miBorderErode;
		private System.Windows.Forms.MenuItem miBorderFrame;
		private System.Windows.Forms.MenuItem miBorderPaintOnCanvas;
		private System.Windows.Forms.MenuItem miColor;
		private System.Windows.Forms.MenuItem miColorBlackAndWhite;
		private System.Windows.Forms.MenuItem miColorBlackAndWhiteDithered;
		private System.Windows.Forms.MenuItem miColorColorize;
		private System.Windows.Forms.MenuItem miColorGrayscale;
		private System.Windows.Forms.MenuItem miColorPosterize;
		private System.Windows.Forms.MenuItem miColorTint;
		private System.Windows.Forms.ColorDialog dlgColor;
		private System.Windows.Forms.MenuItem miFlip;
		private System.Windows.Forms.MenuItem miFlipFlip;
		private System.Windows.Forms.MenuItem miFlipReverse;
		private System.Windows.Forms.MenuItem miFlipReflectLeft;
		private System.Windows.Forms.MenuItem miFlipReflectRight;
		private System.Windows.Forms.MenuItem miFlipReflectTop;
		private System.Windows.Forms.MenuItem miFlipReflectBottom;
		private System.Windows.Forms.MenuItem miRotation;
		private System.Windows.Forms.MenuItem miRotation90;
		private System.Windows.Forms.MenuItem miRotation180;
		private System.Windows.Forms.MenuItem miRotation270;
		private System.Windows.Forms.MenuItem miRotationClip;
		private System.Windows.Forms.MenuItem miRotationNoClip;
		private System.Windows.Forms.MenuItem miSecurity;
		private System.Windows.Forms.MenuItem miSecurityEncrypt;
		private System.Windows.Forms.MenuItem miSecurityDecrypt;
		private System.Windows.Forms.MenuItem miSize;
		private System.Windows.Forms.MenuItem miSizeCropAndResize;
		private System.Windows.Forms.MenuItem miSharpness;
		private System.Windows.Forms.MenuItem miSharpnessAntialias;
		private System.Windows.Forms.MenuItem miSharpnessBlur;
		private System.Windows.Forms.MenuItem miSharpnessSoften;
		private System.Windows.Forms.MenuItem miSharpnessEnhanceEdge;
		private System.Windows.Forms.MenuItem miSharpnessSharpen;
		private System.Windows.Forms.MenuItem miSFX;
		private System.Windows.Forms.MenuItem miSFXNoise;
		private System.Windows.Forms.MenuItem miSFXBlend;
		private System.Windows.Forms.MenuItem miSFXEmboss;
		private System.Windows.Forms.MenuItem miSFXLoupe;
		private System.Windows.Forms.MenuItem miSFXMosaic;
		private System.Windows.Forms.MenuItem miSFXScramble;
		private System.Windows.Forms.MenuItem miSFXSolarize;
		private System.Windows.Forms.MenuItem miSFXSpray;
		private System.Windows.Forms.MenuItem miSFXTexture;
		private System.Windows.Forms.MenuItem miSFXTile;
		private System.Windows.Forms.MenuItem miSFXTwirl;
		private System.Windows.Forms.MenuItem miSFXStaggerRows;
		private System.Windows.Forms.MenuItem miSFXStaggerColumns;
		private System.Windows.Forms.MenuItem miSelections;
		private System.Windows.Forms.MenuItem miSelectionsInvert;
		private System.Windows.Forms.MenuItem miSelectionsTexture;
		private System.Windows.Forms.MenuItem miSelectionsGlobalWandMask;
		private System.Windows.Forms.MenuItem miZoom;
		private System.Windows.Forms.MenuItem miZoomFreeZoom;
		private System.Windows.Forms.Button btnReload;
		private System.Windows.Forms.MenuItem miAttributesSaturation;
		
    	public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
            
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Display = new System.Windows.Forms.PictureBox();
			this.btnUndo = new System.Windows.Forms.Button();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.miAttributes = new System.Windows.Forms.MenuItem();
			this.miAttributesBrightness = new System.Windows.Forms.MenuItem();
			this.miAttributesContrast = new System.Windows.Forms.MenuItem();
			this.miAttributesSaturation = new System.Windows.Forms.MenuItem();
			this.miBorder = new System.Windows.Forms.MenuItem();
			this.miBorderErode = new System.Windows.Forms.MenuItem();
			this.miBorderFrame = new System.Windows.Forms.MenuItem();
			this.miBorderPaintOnCanvas = new System.Windows.Forms.MenuItem();
			this.miColor = new System.Windows.Forms.MenuItem();
			this.miColorBlackAndWhite = new System.Windows.Forms.MenuItem();
			this.miColorBlackAndWhiteDithered = new System.Windows.Forms.MenuItem();
			this.miColorColorize = new System.Windows.Forms.MenuItem();
			this.miColorGrayscale = new System.Windows.Forms.MenuItem();
			this.miColorPosterize = new System.Windows.Forms.MenuItem();
			this.miColorTint = new System.Windows.Forms.MenuItem();
			this.miFlip = new System.Windows.Forms.MenuItem();
			this.miFlipFlip = new System.Windows.Forms.MenuItem();
			this.miFlipReverse = new System.Windows.Forms.MenuItem();
			this.miFlipReflectLeft = new System.Windows.Forms.MenuItem();
			this.miFlipReflectRight = new System.Windows.Forms.MenuItem();
			this.miFlipReflectTop = new System.Windows.Forms.MenuItem();
			this.miFlipReflectBottom = new System.Windows.Forms.MenuItem();
			this.dlgColor = new System.Windows.Forms.ColorDialog();
			this.miRotation = new System.Windows.Forms.MenuItem();
			this.miRotation90 = new System.Windows.Forms.MenuItem();
			this.miRotation180 = new System.Windows.Forms.MenuItem();
			this.miRotation270 = new System.Windows.Forms.MenuItem();
			this.miRotationClip = new System.Windows.Forms.MenuItem();
			this.miRotationNoClip = new System.Windows.Forms.MenuItem();
			this.miSecurity = new System.Windows.Forms.MenuItem();
			this.miSecurityEncrypt = new System.Windows.Forms.MenuItem();
			this.miSecurityDecrypt = new System.Windows.Forms.MenuItem();
			this.miSize = new System.Windows.Forms.MenuItem();
			this.miSizeCropAndResize = new System.Windows.Forms.MenuItem();
			this.miSharpness = new System.Windows.Forms.MenuItem();
			this.miSharpnessAntialias = new System.Windows.Forms.MenuItem();
			this.miSharpnessBlur = new System.Windows.Forms.MenuItem();
			this.miSharpnessSoften = new System.Windows.Forms.MenuItem();
			this.miSharpnessEnhanceEdge = new System.Windows.Forms.MenuItem();
			this.miSharpnessSharpen = new System.Windows.Forms.MenuItem();
			this.miSFX = new System.Windows.Forms.MenuItem();
			this.miSFXNoise = new System.Windows.Forms.MenuItem();
			this.miSFXBlend = new System.Windows.Forms.MenuItem();
			this.miSFXEmboss = new System.Windows.Forms.MenuItem();
			this.miSFXLoupe = new System.Windows.Forms.MenuItem();
			this.miSFXMosaic = new System.Windows.Forms.MenuItem();
			this.miSFXScramble = new System.Windows.Forms.MenuItem();
			this.miSFXSolarize = new System.Windows.Forms.MenuItem();
			this.miSFXSpray = new System.Windows.Forms.MenuItem();
			this.miSFXTexture = new System.Windows.Forms.MenuItem();
			this.miSFXTile = new System.Windows.Forms.MenuItem();
			this.miSFXTwirl = new System.Windows.Forms.MenuItem();
			this.miSFXStaggerRows = new System.Windows.Forms.MenuItem();
			this.miSFXStaggerColumns = new System.Windows.Forms.MenuItem();
			this.miSelections = new System.Windows.Forms.MenuItem();
			this.miSelectionsInvert = new System.Windows.Forms.MenuItem();
			this.miSelectionsTexture = new System.Windows.Forms.MenuItem();
			this.miSelectionsGlobalWandMask = new System.Windows.Forms.MenuItem();
			this.miZoom = new System.Windows.Forms.MenuItem();
			this.miZoomFreeZoom = new System.Windows.Forms.MenuItem();
			this.btnReload = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// Display
			// 
			this.Display.Location = new System.Drawing.Point(16, 40);
			this.Display.Name = "Display";
			this.Display.Size = new System.Drawing.Size(640, 480);
			this.Display.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.Display.TabIndex = 1;
			this.Display.TabStop = false;
			this.Display.MouseDown += new System.Windows.Forms.MouseEventHandler(this.Display_MouseDown);
			// 
			// btnUndo
			// 
			this.btnUndo.Location = new System.Drawing.Point(228, 8);
			this.btnUndo.Name = "btnUndo";
			this.btnUndo.Size = new System.Drawing.Size(72, 24);
			this.btnUndo.TabIndex = 2;
			this.btnUndo.Text = "Undo effect";
			this.btnUndo.Click += new System.EventHandler(this.btnUndo_Click);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.miAttributes,
																					  this.miBorder,
																					  this.miColor,
																					  this.miFlip,
																					  this.miRotation,
																					  this.miSecurity,
																					  this.miSize,
																					  this.miSharpness,
																					  this.miSFX,
																					  this.miSelections,
																					  this.miZoom});
			// 
			// miAttributes
			// 
			this.miAttributes.Index = 0;
			this.miAttributes.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.miAttributesBrightness,
																						 this.miAttributesContrast,
																						 this.miAttributesSaturation});
			this.miAttributes.Text = "Attributes";
			// 
			// miAttributesBrightness
			// 
			this.miAttributesBrightness.Index = 0;
			this.miAttributesBrightness.Text = "Brightness";
			this.miAttributesBrightness.Click += new System.EventHandler(this.miAttributesBrightness_Click);
			// 
			// miAttributesContrast
			// 
			this.miAttributesContrast.Index = 1;
			this.miAttributesContrast.Text = "Contrast";
			this.miAttributesContrast.Click += new System.EventHandler(this.miAttributesContrast_Click);
			// 
			// miAttributesSaturation
			// 
			this.miAttributesSaturation.Index = 2;
			this.miAttributesSaturation.Text = "Saturation";
			this.miAttributesSaturation.Click += new System.EventHandler(this.miAttributesSaturation_Click);
			// 
			// miBorder
			// 
			this.miBorder.Index = 1;
			this.miBorder.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.miBorderErode,
																					 this.miBorderFrame,
																					 this.miBorderPaintOnCanvas});
			this.miBorder.Text = "Border";
			// 
			// miBorderErode
			// 
			this.miBorderErode.Index = 0;
			this.miBorderErode.Text = "Eroder border";
			this.miBorderErode.Click += new System.EventHandler(this.miBorderErode_Click);
			// 
			// miBorderFrame
			// 
			this.miBorderFrame.Index = 1;
			this.miBorderFrame.Text = "Draw frame";
			this.miBorderFrame.Click += new System.EventHandler(this.miBorderFrame_Click);
			// 
			// miBorderPaintOnCanvas
			// 
			this.miBorderPaintOnCanvas.Index = 2;
			this.miBorderPaintOnCanvas.Text = "Paint on canvas";
			this.miBorderPaintOnCanvas.Click += new System.EventHandler(this.miBorderPaintOnCanvas_Click);
			// 
			// miColor
			// 
			this.miColor.Index = 2;
			this.miColor.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.miColorBlackAndWhite,
																					this.miColorBlackAndWhiteDithered,
																					this.miColorColorize,
																					this.miColorGrayscale,
																					this.miColorPosterize,
																					this.miColorTint});
			this.miColor.Text = "Color";
			// 
			// miColorBlackAndWhite
			// 
			this.miColorBlackAndWhite.Index = 0;
			this.miColorBlackAndWhite.Text = "Black and white";
			this.miColorBlackAndWhite.Click += new System.EventHandler(this.miColorBlackAndWhite_Click);
			// 
			// miColorBlackAndWhiteDithered
			// 
			this.miColorBlackAndWhiteDithered.Index = 1;
			this.miColorBlackAndWhiteDithered.Text = "Black and white dithered";
			this.miColorBlackAndWhiteDithered.Click += new System.EventHandler(this.miColorBlackAndWhiteDithered_Click);
			// 
			// miColorColorize
			// 
			this.miColorColorize.Index = 2;
			this.miColorColorize.Text = "Colorize";
			this.miColorColorize.Click += new System.EventHandler(this.miColorColorize_Click);
			// 
			// miColorGrayscale
			// 
			this.miColorGrayscale.Index = 3;
			this.miColorGrayscale.Text = "Grayscale";
			this.miColorGrayscale.Click += new System.EventHandler(this.miColorGrayscale_Click);
			// 
			// miColorPosterize
			// 
			this.miColorPosterize.Index = 4;
			this.miColorPosterize.Text = "Posterize";
			this.miColorPosterize.Click += new System.EventHandler(this.miColorPosterize_Click);
			// 
			// miColorTint
			// 
			this.miColorTint.Index = 5;
			this.miColorTint.Text = "Tint";
			this.miColorTint.Click += new System.EventHandler(this.miColorTint_Click);
			// 
			// miFlip
			// 
			this.miFlip.Index = 3;
			this.miFlip.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.miFlipFlip,
																				   this.miFlipReverse,
																				   this.miFlipReflectLeft,
																				   this.miFlipReflectRight,
																				   this.miFlipReflectTop,
																				   this.miFlipReflectBottom});
			this.miFlip.Text = "Flip, etc.";
			// 
			// miFlipFlip
			// 
			this.miFlipFlip.Index = 0;
			this.miFlipFlip.Text = "Flip";
			this.miFlipFlip.Click += new System.EventHandler(this.miFlipFlip_Click);
			// 
			// miFlipReverse
			// 
			this.miFlipReverse.Index = 1;
			this.miFlipReverse.Text = "Reverse";
			this.miFlipReverse.Click += new System.EventHandler(this.miFlipReverse_Click);
			// 
			// miFlipReflectLeft
			// 
			this.miFlipReflectLeft.Index = 2;
			this.miFlipReflectLeft.Text = "Reflect left";
			this.miFlipReflectLeft.Click += new System.EventHandler(this.miFlipReflectLeft_Click);
			// 
			// miFlipReflectRight
			// 
			this.miFlipReflectRight.Index = 3;
			this.miFlipReflectRight.Text = "Reflect right";
			this.miFlipReflectRight.Click += new System.EventHandler(this.miFlipReflectRight_Click);
			// 
			// miFlipReflectTop
			// 
			this.miFlipReflectTop.Index = 4;
			this.miFlipReflectTop.Text = "Reflect top";
			this.miFlipReflectTop.Click += new System.EventHandler(this.miFlipReflectTop_Click);
			// 
			// miFlipReflectBottom
			// 
			this.miFlipReflectBottom.Index = 5;
			this.miFlipReflectBottom.Text = "Reflect bottom";
			this.miFlipReflectBottom.Click += new System.EventHandler(this.miFlipReflectBottom_Click);
			// 
			// dlgColor
			// 
			this.dlgColor.Color = System.Drawing.Color.Yellow;
			// 
			// miRotation
			// 
			this.miRotation.Index = 4;
			this.miRotation.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.miRotation90,
																					   this.miRotation180,
																					   this.miRotation270,
																					   this.miRotationClip,
																					   this.miRotationNoClip});
			this.miRotation.Text = "Rotation";
			// 
			// miRotation90
			// 
			this.miRotation90.Index = 0;
			this.miRotation90.Text = "Rotate 90 degrees";
			this.miRotation90.Click += new System.EventHandler(this.miRotation90_Click);
			// 
			// miRotation180
			// 
			this.miRotation180.Index = 1;
			this.miRotation180.Text = "Rotate 180 degrees";
			this.miRotation180.Click += new System.EventHandler(this.miRotation180_Click);
			// 
			// miRotation270
			// 
			this.miRotation270.Index = 2;
			this.miRotation270.Text = "Rotate 270 degrees";
			this.miRotation270.Click += new System.EventHandler(this.miRotation270_Click);
			// 
			// miRotationClip
			// 
			this.miRotationClip.Index = 3;
			this.miRotationClip.Text = "Rotate with clipping";
			this.miRotationClip.Click += new System.EventHandler(this.miRotationClip_Click);
			// 
			// miRotationNoClip
			// 
			this.miRotationNoClip.Index = 4;
			this.miRotationNoClip.Text = "Rotate without clipping";
			this.miRotationNoClip.Click += new System.EventHandler(this.miRotationNoClip_Click);
			// 
			// miSecurity
			// 
			this.miSecurity.Index = 5;
			this.miSecurity.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.miSecurityEncrypt,
																					   this.miSecurityDecrypt});
			this.miSecurity.Text = "Security";
			// 
			// miSecurityEncrypt
			// 
			this.miSecurityEncrypt.Index = 0;
			this.miSecurityEncrypt.Text = "Encrypt";
			this.miSecurityEncrypt.Click += new System.EventHandler(this.miSecurityEncrypt_Click);
			// 
			// miSecurityDecrypt
			// 
			this.miSecurityDecrypt.Index = 1;
			this.miSecurityDecrypt.Text = "Decrypt";
			this.miSecurityDecrypt.Click += new System.EventHandler(this.miSecurityDecrypt_Click);
			// 
			// miSize
			// 
			this.miSize.Index = 6;
			this.miSize.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.miSizeCropAndResize});
			this.miSize.Text = "Size";
			// 
			// miSizeCropAndResize
			// 
			this.miSizeCropAndResize.Index = 0;
			this.miSizeCropAndResize.Text = "Crop and resize";
			this.miSizeCropAndResize.Click += new System.EventHandler(this.miSizeCropAndResize_Click);
			// 
			// miSharpness
			// 
			this.miSharpness.Index = 7;
			this.miSharpness.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.miSharpnessAntialias,
																						this.miSharpnessBlur,
																						this.miSharpnessSoften,
																						this.miSharpnessEnhanceEdge,
																						this.miSharpnessSharpen});
			this.miSharpness.Text = "Sharpness";
			// 
			// miSharpnessAntialias
			// 
			this.miSharpnessAntialias.Index = 0;
			this.miSharpnessAntialias.Text = "Antialias";
			this.miSharpnessAntialias.Click += new System.EventHandler(this.miSharpnessAntialias_Click);
			// 
			// miSharpnessBlur
			// 
			this.miSharpnessBlur.Index = 1;
			this.miSharpnessBlur.Text = "Blur";
			this.miSharpnessBlur.Click += new System.EventHandler(this.miSharpnessBlur_Click);
			// 
			// miSharpnessSoften
			// 
			this.miSharpnessSoften.Index = 2;
			this.miSharpnessSoften.Text = "Soften";
			this.miSharpnessSoften.Click += new System.EventHandler(this.miSharpnessSoften_Click);
			// 
			// miSharpnessEnhanceEdge
			// 
			this.miSharpnessEnhanceEdge.Index = 3;
			this.miSharpnessEnhanceEdge.Text = "Enhance edge";
			this.miSharpnessEnhanceEdge.Click += new System.EventHandler(this.miSharpnessEnhanceEdge_Click);
			// 
			// miSharpnessSharpen
			// 
			this.miSharpnessSharpen.Index = 4;
			this.miSharpnessSharpen.Text = "Sharpen";
			this.miSharpnessSharpen.Click += new System.EventHandler(this.miSharpnessSharpen_Click);
			// 
			// miSFX
			// 
			this.miSFX.Index = 8;
			this.miSFX.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				  this.miSFXNoise,
																				  this.miSFXBlend,
																				  this.miSFXEmboss,
																				  this.miSFXLoupe,
																				  this.miSFXMosaic,
																				  this.miSFXScramble,
																				  this.miSFXSolarize,
																				  this.miSFXSpray,
																				  this.miSFXTexture,
																				  this.miSFXTile,
																				  this.miSFXTwirl,
																				  this.miSFXStaggerRows,
																				  this.miSFXStaggerColumns});
			this.miSFX.Text = "Special FX";
			// 
			// miSFXNoise
			// 
			this.miSFXNoise.Index = 0;
			this.miSFXNoise.Text = "Add noise";
			this.miSFXNoise.Click += new System.EventHandler(this.miSFXNoise_Click);
			// 
			// miSFXBlend
			// 
			this.miSFXBlend.Index = 1;
			this.miSFXBlend.Text = "Blend";
			this.miSFXBlend.Click += new System.EventHandler(this.miSFXBlend_Click);
			// 
			// miSFXEmboss
			// 
			this.miSFXEmboss.Index = 2;
			this.miSFXEmboss.Text = "Emboss";
			this.miSFXEmboss.Click += new System.EventHandler(this.miSFXEmboss_Click);
			// 
			// miSFXLoupe
			// 
			this.miSFXLoupe.Index = 3;
			this.miSFXLoupe.Text = "Loupe";
			this.miSFXLoupe.Click += new System.EventHandler(this.miSFXLoupe_Click);
			// 
			// miSFXMosaic
			// 
			this.miSFXMosaic.Index = 4;
			this.miSFXMosaic.Text = "Mosaic";
			this.miSFXMosaic.Click += new System.EventHandler(this.miSFXMosaic_Click);
			// 
			// miSFXScramble
			// 
			this.miSFXScramble.Index = 5;
			this.miSFXScramble.Text = "Scramble";
			this.miSFXScramble.Click += new System.EventHandler(this.miSFXScramble_Click);
			// 
			// miSFXSolarize
			// 
			this.miSFXSolarize.Index = 6;
			this.miSFXSolarize.Text = "Solarize";
			this.miSFXSolarize.Click += new System.EventHandler(this.miSFXSolarize_Click);
			// 
			// miSFXSpray
			// 
			this.miSFXSpray.Index = 7;
			this.miSFXSpray.Text = "Spray";
			this.miSFXSpray.Click += new System.EventHandler(this.miSFXSpray_Click);
			// 
			// miSFXTexture
			// 
			this.miSFXTexture.Index = 8;
			this.miSFXTexture.Text = "Texture";
			this.miSFXTexture.Click += new System.EventHandler(this.miSFXTexture_Click);
			// 
			// miSFXTile
			// 
			this.miSFXTile.Index = 9;
			this.miSFXTile.Text = "Tile";
			this.miSFXTile.Click += new System.EventHandler(this.miSFXTile_Click);
			// 
			// miSFXTwirl
			// 
			this.miSFXTwirl.Index = 10;
			this.miSFXTwirl.Text = "Twirl";
			this.miSFXTwirl.Click += new System.EventHandler(this.miSFXTwirl_Click);
			// 
			// miSFXStaggerRows
			// 
			this.miSFXStaggerRows.Index = 11;
			this.miSFXStaggerRows.Text = "Stagger rows";
			this.miSFXStaggerRows.Click += new System.EventHandler(this.miSFXStaggerRows_Click);
			// 
			// miSFXStaggerColumns
			// 
			this.miSFXStaggerColumns.Index = 12;
			this.miSFXStaggerColumns.Text = "Stagger columns";
			this.miSFXStaggerColumns.Click += new System.EventHandler(this.miSFXStaggerColumns_Click);
			// 
			// miSelections
			// 
			this.miSelections.Index = 9;
			this.miSelections.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.miSelectionsInvert,
																						 this.miSelectionsTexture,
																						 this.miSelectionsGlobalWandMask});
			this.miSelections.Text = "Selections";
			// 
			// miSelectionsInvert
			// 
			this.miSelectionsInvert.Index = 0;
			this.miSelectionsInvert.Text = "Select irregular region and invert selection";
			this.miSelectionsInvert.Click += new System.EventHandler(this.miSelectionsInvert_Click);
			// 
			// miSelectionsTexture
			// 
			this.miSelectionsTexture.Index = 1;
			this.miSelectionsTexture.Text = "Select irregular region and apply texture to selection";
			this.miSelectionsTexture.Click += new System.EventHandler(this.miSelectionsTexture_Click);
			// 
			// miSelectionsGlobalWandMask
			// 
			this.miSelectionsGlobalWandMask.Index = 2;
			this.miSelectionsGlobalWandMask.Text = "Select using global magic wand and mask not selected";
			this.miSelectionsGlobalWandMask.Click += new System.EventHandler(this.miSelectionsGlobalWandMask_Click);
			// 
			// miZoom
			// 
			this.miZoom.Index = 10;
			this.miZoom.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.miZoomFreeZoom});
			this.miZoom.Text = "Zoom";
			// 
			// miZoomFreeZoom
			// 
			this.miZoomFreeZoom.Index = 0;
			this.miZoomFreeZoom.Text = "Free zoom";
			this.miZoomFreeZoom.Click += new System.EventHandler(this.miZoomFreeZoom_Click);
			// 
			// btnReload
			// 
			this.btnReload.Location = new System.Drawing.Point(356, 8);
			this.btnReload.Name = "btnReload";
			this.btnReload.Size = new System.Drawing.Size(88, 23);
			this.btnReload.TabIndex = 3;
			this.btnReload.Text = "Reload image";
			this.btnReload.Click += new System.EventHandler(this.btnReload_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(672, 334);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnReload,
																		  this.btnUndo,
																		  this.Display});
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "Form1";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion


		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		private void Form1_Load(object sender, System.EventArgs e)
		{
		    PixTwix = new PixTwixLib.PixTwixClass() ;	             
			PixTwix.Unlock("your registration code here");
            this.Text = "PixTwix " + PixTwix.GetVersion() + " demo project";			
			path = @".\..\..\" ; // this image path may need editing
			btnUndo.Enabled = false;
            Display.Image = Image.FromFile (path + "kids.jpg");
			undo_file = path + "undo.bmp";
			effect = -1;
			magnification = 1;
			zoomed_left = 0;
			zoomed_top = 0;
			StreamReader reader = new StreamReader(path + "demo.txt"); 
			MessageBox.Show (reader.ReadToEnd());         
		}

		private void Prepare() 
		{
			Bitmap bmp = new Bitmap(Display.Image);
			PixTwix.SetPictureHandle ((System.Int32) bmp.GetHbitmap());	
		    if (PixTwix.UndoSave(undo_file)) btnUndo.Enabled = true;
			else btnUndo.Enabled = false;
		}


		private void UpdateDisplay() 
		{
            Display.Image = Image.FromHbitmap ((System.IntPtr) PixTwix.GetPictureHandle())  ;		
		}


		private void btnUndo_Click(object sender, System.EventArgs e)
		{					 
			if (PixTwix.UndoLoad(undo_file))
			{
				UpdateDisplay();
				btnUndo.Enabled = false;
			}
		}

		private void miAttributesBrightness_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Brightness(20, false)) UpdateDisplay();
		}

		private void miAttributesContrast_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Contrast(30, false)) UpdateDisplay();
		}

		private void miBorderErode_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.ErodeBorder(20, 255, 255, 255)) UpdateDisplay();
		}

		private void miAttributesSaturation_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Saturation(20, false)) UpdateDisplay();
		}

		private void miBorderFrame_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Frame(16, 50, 50, 250, 220, 220, 220)) UpdateDisplay();
		}

		private void miBorderPaintOnCanvas_Click(object sender, System.EventArgs e)
		{
			Prepare();
			int w = PixTwix.GetPictureWidth();
			int h = PixTwix.GetPictureHeight();
			if (PixTwix.PaintOnCanvas(w + 50, h + 50, 25, 25, 255, 255, 255, 10, 10, 6, 128, 128, 128)) UpdateDisplay();
		}

		private void miColorBlackAndWhite_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.BlackAndWhite(127, false)) UpdateDisplay();
		}

		private void miColorBlackAndWhiteDithered_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.BlackAndWhiteDithered(0, false)) UpdateDisplay();
		}

		private void miColorColorize_Click(object sender, System.EventArgs e)
		{
			dlgColor.ShowDialog ();
			Prepare();
			if (PixTwix.Colorize(dlgColor.Color.R, dlgColor.Color.G, dlgColor.Color.B, false)) UpdateDisplay();
		}

		private void miColorGrayscale_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Grayscale(PixTwixLib.TxGrayscaleMode.gsWeighted, false)) UpdateDisplay();
		}

		private void miColorPosterize_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Posterize(3, 3, 3, false)) UpdateDisplay();
		}

		private void miColorTint_Click(object sender, System.EventArgs e)
		{
			dlgColor.ShowDialog() ;
			Prepare();
			if (PixTwix.Tint(dlgColor.Color.R, dlgColor.Color.G, dlgColor.Color.B, false)) UpdateDisplay();
		}

		private void miFlipFlip_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Flip()) UpdateDisplay();
		}

		private void miFlipReverse_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Reverse()) UpdateDisplay();
		}

		private void miFlipReflectLeft_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Reflect(PixTwixLib.TxReflectionMode.rmLeft)) UpdateDisplay();
		}

		private void miFlipReflectRight_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Reflect(PixTwixLib.TxReflectionMode.rmRight)) UpdateDisplay();
		}

		private void miFlipReflectTop_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Reflect(PixTwixLib.TxReflectionMode.rmTop)) UpdateDisplay();
		}

		private void miFlipReflectBottom_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Reflect(PixTwixLib.TxReflectionMode.rmBottom)) UpdateDisplay();
		}

		private void miRotation90_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Rotate90()) UpdateDisplay();
		}

		private void miRotation180_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Rotate180()) UpdateDisplay();
		}

		private void miRotation270_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Rotate270()) UpdateDisplay();
		}

		private void miRotationClip_Click(object sender, System.EventArgs e)
		{
			Prepare();
			int cx = PixTwix.GetPictureWidth() / 2;
			int cy = PixTwix.GetPictureHeight() / 2;
			if (PixTwix.RotatePicture(cx, cy, 45, 255, 255, 255)) UpdateDisplay();
		}

		private void miRotationNoClip_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.RotatePictureEx(45, 255, 255, 255)) UpdateDisplay();
		}

		private void miSecurityEncrypt_Click(object sender, System.EventArgs e)
		{
			Prepare();
			string password = "my password";
			if (PixTwix.Encrypt(password)) UpdateDisplay();
		}

		private void miSecurityDecrypt_Click(object sender, System.EventArgs e)
		{
			Prepare();
			string password = "my password";
			if (PixTwix.Decrypt(password)) UpdateDisplay();
		}

		private void miSizeCropAndResize_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.CropPicture(0, 0, 400, 300))
			  if (PixTwix.ResizePicture(640, 480, true)) UpdateDisplay();
		}

		private void miSharpnessAntialias_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Antialias(false)) UpdateDisplay();
		}

		private void miSharpnessBlur_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.BlurMore(false)) UpdateDisplay();
		}

		private void miSharpnessSoften_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.SoftenMore(false)) UpdateDisplay();
		}

		private void miSharpnessEnhanceEdge_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.EnhanceEdge(false)) UpdateDisplay();
		}

		private void miSharpnessSharpen_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Sharpen(false)) UpdateDisplay();
		}

		private void miSFXNoise_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.AddNoise(50, true, false)) UpdateDisplay();
		}

		private void miSFXBlend_Click(object sender, System.EventArgs e)
		{
			Prepare();
			Bitmap bmp = new Bitmap(Image.FromFile(path + "sunset.jpg"));
			PixTwix.SetSecondaryPictureHandle ((System.Int32) bmp.GetHbitmap());	
			if (PixTwix.Blend(50, 50, false)) UpdateDisplay();
		}

		private void miSFXEmboss_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Emboss(PixTwixLib.TxEmbossDirection.edNorthEast, 3, 127, false)) UpdateDisplay();
		}

		private void miSFXLoupe_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show (MSG_LOUPE);
			effect = FX_LOUPE;
		}

		private void Display_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			switch (effect) {
			
				case FX_LOUPE:
					Prepare();
					if (PixTwix.Loupe(e.X, e.Y, 120, 60)) UpdateDisplay();
					break;

				case FX_TWIRL:
					Prepare();
					if (PixTwix.Twirl(e.X, e.Y, 120)) UpdateDisplay();
					break;

				case FX_MAGICWAND:
					PixTwix.SelectNone();
					PixTwix.SelectUsingGlobalMagicWand (e.X, e.Y, 15, PixTwixLib.TxMagicWandMode.mwRGB);
					if (PixTwix.MaskNotSelected(0, 0, 0)) UpdateDisplay();			
					break;

				case FX_ZOOM:
					int cx = zoomed_left + e.X / magnification;
					int cy = zoomed_top + e.Y / magnification;
                    if (e.Button == MouseButtons.Left) magnification = magnification * 2;
                    else if (e.Button == MouseButtons.Right) magnification = magnification / 2;
                    if (magnification < 1) magnification = 1;
                    if (PixTwix.Zoom(cx, cy, magnification)) Display.Image = Image.FromHbitmap ((System.IntPtr) PixTwix.GetSecondaryPictureHandle()) ;							
					zoomed_left = PixTwix.GetZoomedLeft();
					zoomed_top = PixTwix.GetZoomedTop();
					break;
			}
		}

		private void miSFXMosaic_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Mosaic(10, 10, false)) UpdateDisplay();
		}

		private void miSFXScramble_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Scramble(100, 75)) UpdateDisplay();
		}

		private void miSFXSolarize_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Solarize(80, 80, 80, true, false)) UpdateDisplay();
		}

		private void miSFXSpray_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.Spray(20, false)) UpdateDisplay();
		}

		private void miSFXTexture_Click(object sender, System.EventArgs e)
		{
			Prepare();
			Bitmap bmp = new Bitmap(Image.FromFile(path + "texture.jpg"));
			PixTwix.SetSecondaryPictureHandle ((System.Int32) bmp.GetHbitmap());	
			if (PixTwix.Texture(0, PixTwixLib.TxTextureMode.tmStretched, false)) UpdateDisplay();
		}

		private void miSFXTile_Click(object sender, System.EventArgs e)
		{
			Prepare();
			if (PixTwix.TileEx(100, 75)) UpdateDisplay();
		}

		private void miSFXTwirl_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show (MSG_TWIRL);
			effect = FX_TWIRL;
		}

		private void miSFXStaggerRows_Click(object sender, System.EventArgs e)
		{
			Prepare();
			for (int i = 1; i < 6; i++) PixTwix.StaggerRows (true);
			UpdateDisplay();
		}

		private void miSFXStaggerColumns_Click(object sender, System.EventArgs e)
		{
			Prepare();
			for (int i = 1; i < 6; i++) PixTwix.StaggerColumns (true);
			UpdateDisplay();		
		}

		private void miSelectionsInvert_Click(object sender, System.EventArgs e)
		{
			Display.Image = Image.FromFile (path + "kids.jpg");
			Prepare();
			PixTwix.SelectNone();
			PixTwix.SelectEllipse (10, 10, 250, 200);
			PixTwix.SelectEllipse (400, 70, 635, 500);
			if (PixTwix.Negative(true, true, true, true)) UpdateDisplay();
		}

		private void miSelectionsTexture_Click(object sender, System.EventArgs e)
		{
			Display.Image = Image.FromFile (path + "kids.jpg");
			Prepare();
			PixTwix.SelectNone();
			PixTwix.SelectEllipse (10, 10, 250, 200);
			PixTwix.SelectEllipse (400, 70, 635, 500);
			Bitmap bmp = new Bitmap(Image.FromFile(path + "texture.jpg"));
			PixTwix.SetSecondaryPictureHandle ((System.Int32) bmp.GetHbitmap());	
			if (PixTwix.Texture(0, PixTwixLib.TxTextureMode.tmStretched, true)) UpdateDisplay();
		}

		private void miSelectionsGlobalWandMask_Click(object sender, System.EventArgs e)
		{
			Display.Image = Image.FromFile (path + "kids.jpg");
			Prepare();
			MessageBox.Show(MSG_MAGICWAND);
			effect = FX_MAGICWAND;
		}

		private void miZoomFreeZoom_Click(object sender, System.EventArgs e)
		{
			Prepare();
			MessageBox.Show(MSG_ZOOM);
			effect = FX_ZOOM;
		}

		private void btnReload_Click(object sender, System.EventArgs e)
		{
			Display.Image = Image.FromFile (path + "kids.jpg");
			effect = -1;
			magnification = 1;
			zoomed_left = 0;
			zoomed_top = 0;
		}


	}
}
